﻿using System;
using System.Collections.Generic;
using System.Text;
using Xunit;

namespace ClassLibrary.XUnitTests
{
    public class PrimeServiceTest
    {
        private readonly PrimeService _primeService;

        public PrimeServiceTest()
        {
            _primeService = new PrimeService();
        }


        //[Fact]
        [Theory]
        [InlineData(-1)]
        [InlineData(0)]
        [InlineData(1)]
        public void IsPrime_ReturnFalse_WhenValueOf1(int value)
        {
            //数据
            int thisValue = value;

            //行为
            var result = _primeService.IsPrime(thisValue);

            //断言
            Assert.False(result);
        }

        [Fact]
        public void IsPrime_CanThrowNotImplementedException_WhenValueNot1()
        {
            //数据
            int thisValue = 2;

            //断言
            //Assert.Throws<NotImplementedException>(()=>  _primeService.IsPrime(thisValue) );
        }
    }
}
