﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Text.Json.Serialization;

namespace HelloService.Controllers
{
    [Route("dapr/subscribe_________")]
    [ApiController]
    public class DaprSubscribeController : ControllerBase
    {
        public class DaprSubscribeOutput
        {
            [JsonPropertyName("pubsubname")]
            public string? PubSubName { get; set; }

            [JsonPropertyName("topic")]
            public string? Topic { get; set; }

            [JsonPropertyName("route")]
            public string? Route { get; set; }
        }

        [HttpGet]
        public ActionResult<DaprSubscribeOutput[]> Get()
        {
            return Ok(new DaprSubscribeOutput[]
           {
                new DaprSubscribeOutput
                {
                    PubSubName="mypubsub",
                    Topic="newOrder",
                    Route="/api/orders"
                }
           });
        }
    }
}
