﻿
using Dapr.Client;

using var daprClient = new DaprClientBuilder().UseGrpcEndpoint("http://localhost:60001").Build();

while (true)
{
    var data = new
    {
        OrderId = Random.Shared.Next().ToString(),
        ProductId = Random.Shared.Next().ToString(),
        Amount = Random.Shared.Next(1, 10)
    };

    Dictionary<string, string> metadata = new() 
    {
        { "ttlInSeconds","120" },
        { "rawPayload","true"}
    };

    await daprClient.PublishEventAsync("mypubsub", "newOrder", data, metadata);

    await Task.Delay(TimeSpan.FromSeconds(3));
}

