﻿using System.Net.Mime;
using System.Text.Json.Serialization;

namespace HelloService
{
	/// <summary>
	/// Represents a CloudEvent without data.
	/// </summary>        
	public class CustomCloudEvent
	{
		/// <summary>
		/// CloudEvent 'source' attribute.
		/// </summary>
		[JsonPropertyName("source")]
		public Uri? Source { get; init; }

		/// <summary>
		/// CloudEvent 'type' attribute.
		/// </summary>
		[JsonPropertyName("type")]
		public string? Type { get; init; }

		/// <summary>
		/// CloudEvent 'subject' attribute.
		/// </summary>
		[JsonPropertyName("subject")]
		public string? Subject { get; init; }
	}

	/// <summary>
	/// Represents a CloudEvent with typed data.
	/// </summary>
	public class CustomCloudEvent<TData> : CustomCloudEvent
	{
		/// <summary>
		/// Initialize a new instance of the <see cref="CloudEvent{TData}"/> class.
		/// </summary>
		public CustomCloudEvent(TData data)
		{
			Data = data;
		}

		/// <summary>
		/// CloudEvent 'data' content.
		/// </summary>
		public TData Data { get; }

		/// <summary>
		/// Gets event data.
		/// </summary>
		[JsonPropertyName("datacontenttype")]
		public string DataContentType { get; } = MediaTypeNames.Application.Json;
	}
}
