using Dapr;
using Dapr.Client;
using Microsoft.AspNetCore.Mvc;

namespace StateExample.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class WeatherForecastController : ControllerBase
    {
        private readonly ILogger<WeatherForecastController> _logger;

        private readonly DaprClient _daprClient;

        public WeatherForecastController(ILogger<WeatherForecastController> logger, DaprClient daprClient)
        {
            _logger = logger;
            _daprClient = daprClient;

            //UseDarpClientSaveState().Wait();
        }

        [NonAction]
        private async Task UseDarpClientSaveState()
        {
            WeatherForecast chongqing = new() { Temperature = 40, Summary = "Hot" };
            WeatherForecast shanghai = new() { Temperature = 26, Summary = "Cool" };

            await _daprClient.SaveStateAsync("mystore", nameof(chongqing), chongqing);
            await _daprClient.SaveStateAsync("mystore", nameof(shanghai), shanghai);

            WeatherForecast weather = await _daprClient.GetStateAsync<WeatherForecast>("mystore", nameof(shanghai));

            var weatherEntry = await _daprClient.GetStateEntryAsync<WeatherForecast>("mystore", nameof(shanghai));

            weatherEntry.Value = new() { Temperature = 39, Summary = "Hot" };

            await weatherEntry.SaveAsync();

            _logger.LogInformation(System.Text.Json.JsonSerializer.Serialize(weather));
        }

        [HttpGet("{city=chongqing}")]
        public ActionResult<WeatherForecast> Get([FromState("mystore", "city")] StateEntry<WeatherForecast> forecast)
        {
            if (forecast.Value is null)
            {
                return NotFound();
            }

            return forecast.Value;
        }

        [HttpPut("{city=shanghai}")]
        public async Task<IActionResult> Put(WeatherForecast updatedForecast, [FromState("mystore", "city")] StateEntry<WeatherForecast> currentForecast)
        {
            currentForecast.Value = updatedForecast;

            if (await currentForecast.TrySaveAsync())
            {
                return Ok();
            }

            return BadRequest();
        }
    }
}