﻿using Dapr.AppCallback.Autogen.Grpc.v1;
using Dapr.Client.Autogen.Grpc.v1;
using Google.Protobuf.WellKnownTypes;
using Grpc.Core;
using GrpcService;

namespace Service.Services
{
    public class HelloService : AppCallback.AppCallbackBase
    {
        private readonly ILogger<HelloService> _logger;

        public HelloService(ILogger<HelloService> logger)
        {
            _logger = logger;
        }

        public override async Task<InvokeResponse> OnInvoke(InvokeRequest request, ServerCallContext context)
        {
            return request.Method switch
            {
                "sayhello" => await SayHello(request, context),
                _ => throw new NotImplementedException(),
            };
        }

        public async Task<InvokeResponse> SayHello(InvokeRequest request, ServerCallContext context)
        {
            _logger.LogInformation(context.Method);

            var helloRequest = request.Data.Unpack<HelloRequest>();

            var helloReply = new HelloReply
            {
                Message = "Hello " + helloRequest.Name
            };

            var response = new InvokeResponse
            {
                Data = Any.Pack(helloReply)
            };

            return await Task.FromResult(response);
        }
    }

}
