﻿using Microsoft.AspNetCore.Mvc;
using OrderProcessor.Models;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace OrderProcessor.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class OrdersController : ControllerBase
    {
        static List<Order> orders = new() { new Order { Id = 1, Price = 11.11 }, new Order { Id = 2, Price = 22.22 } };

        // GET: api/<OrdersController>
        [HttpGet]
        public IEnumerable<Order> Get()
        {
            return orders;
        }

        // GET api/<OrdersController>/5
        [HttpGet("{id}")]
        public Order Get(int id)
        {
            return orders.First(o => o.Id == id);
        }

        // POST api/<OrdersController>
        [HttpPost]
        public void Post([FromBody] Order value)
        {
            orders.Add(value);
        }

        // PUT api/<OrdersController>/5
        [HttpPut("{id}")]
        public void Put(int id, [FromBody] Order value)
        {
            var order = orders.First(o => o.Id == id);
            order.Id = value.Id;
            order.Price=value.Price;
        }

        // DELETE api/<OrdersController>/5
        [HttpDelete("{id}")]
        public void Delete(int id)
        {
            orders.Remove(orders.First(o => o.Id == id));
        }
    }
}
