﻿
using Dapr.Client;
using OrderCheckout;
using System.Net.Http.Headers;
using System.Net.Http.Json;
using System.Net.Mime;
using System.Text.Json;

#region Use Http Client

//var httpClient = new HttpClient();

//httpClient.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue(MediaTypeNames.Application.Json));

//httpClient.DefaultRequestHeaders.Add("dapr-app-id", "orderprocessor");

//JsonSerializerOptions options = new(JsonSerializerDefaults.Web)
//{
//    WriteIndented = true
//};

//var orders = await httpClient.GetFromJsonAsync<IEnumerable<Order>>("http://localhost:3501/api/orders", options);

#endregion

#region DaprClient Create HttpClient

//var httpClient = DaprClient.CreateInvokeHttpClient(daprEndpoint: "http://localhost:3501", appId: "orderprocessor");

//var orders = await httpClient.GetFromJsonAsync<IEnumerable<Order>>("api/orders");

#endregion

#region DaprClient Invoke Method

var daprClient = new DaprClientBuilder().UseGrpcEndpoint("http://localhost:50002").Build();

var orders = await daprClient.InvokeMethodAsync<IEnumerable<Order>>(HttpMethod.Get, "orderprocessor", "api/Orders");

#endregion

orders ??= Enumerable.Empty<Order>();

foreach (var item in orders)
{
    Console.WriteLine(item);
}