﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc.Formatters;
using Microsoft.Net.Http.Headers;
using ProtoBuf;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Threading.Tasks;
namespace AspNetCoreWebApiSamples.Formatters
{
    public class ProtobufOutputFormatter : OutputFormatter
    {
        public ProtobufOutputFormatter()
        {
            SupportedMediaTypes.Add(MediaTypeHeaderValue.Parse("application/x-protobuf"));
        }

        public override Task WriteResponseBodyAsync(OutputFormatterWriteContext context)
        {
            using (MemoryStream stream = new MemoryStream())
            {
                Serializer.Serialize(stream, context.Object);

                string hexString = BitConverter.ToString(stream.ToArray());

                context.HttpContext.Response.WriteAsync(hexString);
            }

            return Task.CompletedTask;
        }
    }
}
