﻿using Microsoft.AspNetCore.Mvc.Formatters;
using Microsoft.Net.Http.Headers;
using ProtoBuf;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;

namespace AspNetCoreWebApiSamples.Formatters
{
    public class ProtobufInputFormatter : InputFormatter
    {
        public ProtobufInputFormatter()
        {
            SupportedMediaTypes.Add(MediaTypeHeaderValue.Parse("application/x-protobuf"));
        }

        public override Task<InputFormatterResult> ReadRequestBodyAsync(InputFormatterContext context)
        {
            var request = context.HttpContext.Request;
            var stream = new StreamReader(request.Body);
            var body = stream.ReadToEnd();

            using (MemoryStream memoryStream = new MemoryStream(FromHexString(body)))
            {
                object result = Serializer.Deserialize(context.ModelType, memoryStream);
                return InputFormatterResult.SuccessAsync(result);
            }
        }

        private byte[] FromHexString(string hexString)
        {
            hexString = hexString.Replace("-", "");
            byte[] raw = new byte[hexString.Length / 2];
            for (int i = 0; i < raw.Length; i++)
            {
                raw[i] = Convert.ToByte(hexString.Substring(i * 2, 2), 16);
            }
            return raw;
        }
    }
}
