﻿using ProtoBuf;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Threading.Tasks;

namespace AspNetCoreWebApiSamples.DataAccess
{
    [ProtoContract]
    public class Product
    {
        [Key]
        [ProtoMember(1)]
        public int ProductID { get; set; }

        [ProtoMember(2)]
        public int Count { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        [Required]
        [ProtoMember(3)]
        [MaxLength(60)]
        public string Name { get; set; }

        /// <summary>
        /// 产品描述
        /// </summary>
        [MaxLength(200)]
        [ProtoMember(4)]
        public string Description { get; set; }
    }
}
