﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using AppPartsSamples.Extensions;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.ApplicationParts;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;

namespace AppPartsSamples
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            services.Configure<CookiePolicyOptions>(options =>
            {
                // This lambda determines whether user consent for non-essential cookies is needed for a given request.
                options.CheckConsentNeeded = context => true;
                options.MinimumSameSitePolicy = SameSiteMode.None;
            });

            var pluginsDir = Path.Combine(Directory.GetCurrentDirectory(), "Plugins");

            var plugins = Directory.GetFiles(pluginsDir).Where(f => Path.GetExtension(f) == ".dll");

            //var mvcBuilder = services.AddMvc().SetCompatibilityVersion(CompatibilityVersion.Version_2_1);

            //foreach (string plugin in plugins)
            //{
            //    Assembly assembly = Assembly.LoadFile(plugin);
            //    mvcBuilder.AddApplicationPart(assembly);
            //}

            services.AddMvc().ConfigureApplicationPartManager(apm =>
            {
                apm.FeatureProviders.Add(new ServiceControllerFeatureProvider());

                var dependentLibrary = apm.ApplicationParts.FirstOrDefault(part => part.Name == "MyLib");

                if (dependentLibrary != null)
                {
                    apm.ApplicationParts.Remove(dependentLibrary);
                }

                foreach (string plugin in plugins)
                {
                    Assembly assembly = Assembly.LoadFile(plugin);
                    apm.ApplicationParts.Add(new AssemblyPart(assembly));
                }

            }).SetCompatibilityVersion(CompatibilityVersion.Version_2_1);

        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IHostingEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Home/Error");
            }

            app.UseStaticFiles();
            app.UseCookiePolicy();

            app.UseMvc(routes =>
            {
                routes.MapRoute(
                    name: "default",
                    template: "{controller=Home}/{action=Index}/{id?}");
            });
        }
    }
}
