﻿using Microsoft.AspNetCore.Mvc.ApplicationParts;
using Microsoft.AspNetCore.Mvc.Controllers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;

namespace AppPartsSamples.Extensions
{
    public class ServiceControllerFeatureProvider : IApplicationFeatureProvider<ControllerFeature>
    {
        public void PopulateFeature(IEnumerable<ApplicationPart> parts, ControllerFeature feature)
        {
            var assemblyParts = parts.Where(p => p is AssemblyPart&&p.Name== "MyControllerLibrary").Cast<AssemblyPart>();

            foreach (var assemblyPart in assemblyParts)
            {
                var services = assemblyPart.Assembly.GetTypes().Where(t => t.Name.EndsWith("Service"));

                foreach (Type service in services)
                {
                    feature.Controllers.Add(service.GetTypeInfo());
                }
            }
        }
    }
}
