﻿using FilterSamples.Services;
using Microsoft.AspNetCore.Mvc.Filters;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FilterSamples.Filters
{
    public class AddHeaderFilterWithDiFilter :ResultFilterAttribute
    {
        private readonly IDateTimeService dateTimeService;

        public AddHeaderFilterWithDiFilter(IDateTimeService dateTimeService)
        {
            this.dateTimeService = dateTimeService;
        }

        public override void OnResultExecuting(ResultExecutingContext context)
        {
            context.HttpContext.Response.Headers.Add("time",dateTimeService.Now.ToString());
            base.OnResultExecuting(context);
        }
    }
}
