﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using FilterSamples.Models;
using FilterSamples.Filters;

namespace FilterSamples.Controllers
{
    public class HomeController : Controller
    {
        [AddHeaderWithFactory]
        public IActionResult Index(int id)
        {
            return View();
        }

        [AddHeader("test","www.xcode.me")]
        public IActionResult About()
        {
            ViewData["Message"] = "Your application description page.";

            return View();
        }

        [ServiceFilter(typeof(AddHeaderFilterWithDiFilter))]
        [SampleActionFilterAttribute]
        [CustomExceptionFilter]
        [MiddlewareFilter(typeof(MyMvcMiddleware))]
        public IActionResult Contact()
        {
            int a = 1;
            int b = 0;
            a = a / b;

            ViewData["Message"] = "Your contact page.";

            return View();
        }

        public IActionResult Privacy()
        {
            return View();
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }

        [HttpPost]
        [ValidateModel]
        public IActionResult Create(object user)
        {
            return View();
        }
    }
}
