﻿using Consul;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using System;
using System.Linq;
using System.Net.Http;
using System.Threading.Tasks;

namespace ServiceB.Controllers
{
    [ApiController]
    [Route("[controller]")]
    public class TestController : ControllerBase
    {
        private static readonly Random random = new Random();

        private readonly IConfiguration _configuration;

        private readonly IHttpClientFactory _httpClientFactory;

        public TestController(IConfiguration configuration, IHttpClientFactory httpClientFactory)
        {
            _configuration = configuration;
            _httpClientFactory = httpClientFactory;
        }

        [HttpGet]
        public async Task<IActionResult> Get()
        {
            string consulAddress = _configuration["Consuls:ConsulAddress"];

            using (ConsulClient consulClient = new ConsulClient(a => a.Address = new Uri(consulAddress)))
            {
                var services = consulClient.Catalog.Service("ServiceA").Result.Response;

                if (services != null && services.Any())
                {
                    // 模拟随机一台进行请求，这里只是测试，可以选择合适的负载均衡框架

                    var service = services.ElementAt(random.Next(services.Count()));

                    HttpClient client = _httpClientFactory.CreateClient();

                    var response = await client.GetAsync($"http://{service.ServiceAddress}:{service.ServicePort}/Hello");
                    return Content(await response.Content.ReadAsStringAsync());
                }
            }

            return NotFound();
        }
    }
}
