﻿using Microsoft.AspNetCore.Mvc.Filters;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FilterSamples.Filters
{
    public class AddHeaderAttribute : ResultFilterAttribute
    {
        private readonly string name;

        private readonly string value;

        public AddHeaderAttribute(string name,string value)
        {
            this.name = name;
            this.value = value;
        }

        public override void OnResultExecuting(ResultExecutingContext context)
        {
            context.HttpContext.Response.Headers.Add(this.name, this.value);
            base.OnResultExecuting(context);
        }
    }
}
