﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using DependencyInjectionSamples.Services;
using Microsoft.AspNetCore.Mvc;

namespace DependencyInjectionSamples.Controllers
{
    public class DateTimeController : Controller
    {
        private readonly IDateTimeService dateTimeService;

        public DateTimeController(IDateTimeService dateTimeService)
        {
            this.dateTimeService = dateTimeService;
        }

        public IActionResult Index1()
        {
            return Content(dateTimeService.Now.ToString());
        }

        public IActionResult Index2([FromServices]IDateTimeService dateTimeService)
        {
            return Content(dateTimeService.Now.ToString());
        }
    }
}