﻿using Microsoft.AspNetCore.Mvc.ApplicationModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace AppModelSamples.Conventions
{
    [AttributeUsage(AttributeTargets.Method)]
    public class CustomActionNameAttribute : Attribute, IActionModelConvention
    {
        private readonly string actionName;

        public CustomActionNameAttribute(string actionName)
        {
            this.actionName = actionName;
        }

        public void Apply(ActionModel action)
        {
            action.ActionName = actionName;
        }
    }
}
