﻿using Ocelot.Middleware;
using Ocelot.Middleware.Multiplexer;
using System;
using System.Buffers;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Text.Json;
using System.Threading.Tasks;

namespace ApiGateways
{
    public class MyDefinedAggregator : IDefinedAggregator
    {
        public async Task<DownstreamResponse> Aggregate(List<DownstreamContext> responses)
        {

            var bufferWriter = new ArrayBufferWriter<byte>();

            await using (var writer = new Utf8JsonWriter(bufferWriter))
            {
                writer.WriteStartObject();

                foreach (var response in responses)
                {
                    var stream = await response.DownstreamResponse.Content.ReadAsStreamAsync();
                    JsonDocument json = await JsonDocument.ParseAsync(stream);

                    string apiName = json.RootElement.GetProperty("apiName").GetString();
                    long timeStamp= json.RootElement.GetProperty("timeStamp").GetInt64();

                    writer.WriteNumber(apiName, timeStamp);
                }

                writer.WriteString("date", DateTime.Now);

                writer.WriteEndObject();

                await writer.FlushAsync();
            }

            var headers = responses.SelectMany(x => x.DownstreamResponse.Headers).ToList();

            var content = new ByteArrayContent(bufferWriter.WrittenSpan.ToArray())
            {
                Headers = { ContentType = new MediaTypeHeaderValue("application/json") }
            };

            return new DownstreamResponse(content, HttpStatusCode.OK, headers, null);
        }
    }
}
