﻿using Microsoft.AspNetCore.Mvc.ApplicationModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MvcControllderSamples.Extensions
{
    public class NamespaceRoutingConvention : IControllerModelConvention
    {
        private readonly string baseNamespace;

        public NamespaceRoutingConvention(string baseNamespace= "MvcControllderSamples")
        {
            this.baseNamespace = baseNamespace;
        }

        public void Apply(ControllerModel controller)
        {
            bool hasRouteAttributes = controller.Selectors.Any(selecter => selecter.AttributeRouteModel != null);

            if (hasRouteAttributes)
            {
                return;
            }

            var nameSpace = controller.ControllerType.Namespace;

            if (string.IsNullOrWhiteSpace(nameSpace))
            {
                return;
            }

            nameSpace = nameSpace.Replace(baseNamespace, string.Empty);

            StringBuilder template = new StringBuilder();

            template.Append(nameSpace.Replace(".", "/"));
            template.Append("/[controller]/[action]");

            foreach (var selector in controller.Selectors)
            {
                selector.AttributeRouteModel = new AttributeRouteModel {
                    Template = template.ToString()
                };
            }
        }
    }
}
