﻿using Microsoft.AspNetCore.Mvc.ActionConstraints;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace MvcControllderSamples.Extensions
{
    public class CountrySpecificAttribute : Attribute, IActionConstraint
    {
        private readonly string countryCode;

        public CountrySpecificAttribute(string countryCode)
        {
            this.countryCode = countryCode;
        }

        public int Order => 0;

        public bool Accept(ActionConstraintContext context)
        {
            return string.Equals(context.RouteContext.RouteData.Values["country"].ToString(),countryCode,StringComparison.OrdinalIgnoreCase);
        }
    }
}
