﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Infrastructure;
using Microsoft.AspNetCore.Mvc.Routing;
using Microsoft.AspNetCore.Routing;

namespace RouteExample.Controllers
{
    public class MyBookTestController : Controller
    {
        private readonly LinkGenerator _linkGenerator;
        private readonly IUrlHelper _urlHelper;

        public MyBookTestController(LinkGenerator linkGenerator, IUrlHelperFactory urlHelperFactory, IActionContextAccessor actionContextAccessor)
        {
            _linkGenerator = linkGenerator;
            _urlHelper = urlHelperFactory.GetUrlHelper(actionContextAccessor.ActionContext);
        }

        public IActionResult MyIndex(int id)
        {
            string url1 = Url.Action("JavaBook", "BookStoreExample");
            string url2 = _urlHelper.Action("JavaBook", "BookStoreExample");
            string url3 = _linkGenerator.GetPathByAction("JavaBook", "BookStoreExample");

            Console.WriteLine(id);

            return Content(string.Join(System.Environment.NewLine, new string[] { url1, url2, url3 }));
        }
    }
}