﻿using Microsoft.AspNetCore.Razor.TagHelpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace MvcViewSamples.TagHelpers
{
    public class EmailTagHelper: TagHelper
    {
        private const string Domain = "xcode.me";

        public string MailTo { get; set; }

        public override void Process(TagHelperContext context, TagHelperOutput output)
        {
            output.TagName = "a";
            var address = MailTo + "@" + Domain;
            output.Attributes.SetAttribute("href","mailto:"+address);
            output.Content.SetContent(address);
        }
    }
}
