﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.ModelBinding;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Options;
using ModelBindSamples.Binders;
using ModelBindSamples.Models;

namespace ModelBindSamples.Controllers
{
    public class HomeController : Controller
    {

        private readonly MvcOptions mvcOptions;

        public HomeController(IOptions<MvcOptions> optionsAccesser)
        {
            this.mvcOptions = optionsAccesser.Value;
        }

        public IActionResult Index([FromHeader]int id)
        {
            return View();
        }

        //geo.lat=123&geo.lng=55
        public IActionResult CreateGeo([ModelBinder(BinderType = typeof(GeolocationModelBinder))]Geolocation geo)
        {
            return null;
        }

        //[FromHeader]、[FromQuery]、[FromRoute]、[FromForm]

        //[FromServices]

        //[FromBody]

        //[ModelBinder]

        public IActionResult Array(string[] ids)
        {
            return Content(string.Concat(ids));
        }

        public IActionResult Upload(IFormFile formFile)
        {
            return null;
        }

        public IActionResult Dict(Dictionary<string,string> kv)
        {
            return Content(string.Concat(kv.Keys.ToArray()));
        }

        public IActionResult CreateUser(int id, string name, [FromServices]ILogger logger)
        {
            return Content("OK");
        }


        public IActionResult About()
        {
            ViewData["Message"] = "Your application description page.";

            return View();
        }

        public IActionResult Contact()
        {
            ViewData["Message"] = "Your contact page.";

            return View();
        }

        public IActionResult Privacy()
        {
            return View();
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
