﻿using Microsoft.AspNetCore.Mvc.ModelBinding;
using ModelBindSamples.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace ModelBindSamples.Binders
{
    public class GeolocationBinderProvider : IModelBinderProvider
    {
        public IModelBinder GetBinder(ModelBinderProviderContext context)
        {
            if (context==null)
            {
                throw new ArgumentNullException(nameof(context));
            }

            if (context.Metadata.ModelType==typeof(Geolocation))
            {
                return new GeolocationModelBinder();
            }

            return null;
        }
    }
}
