﻿using Microsoft.AspNetCore.Mvc.ModelBinding;
using ModelBindSamples.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace ModelBindSamples.Binders
{
    public class GeolocationModelBinder : IModelBinder
    {
        public Task BindModelAsync(ModelBindingContext bindingContext)
        {
            if (bindingContext==null)
            {
                throw new ArgumentNullException(nameof(bindingContext));
            }

            var valueProviderReslut = bindingContext.ValueProvider.GetValue(bindingContext.ModelName);

            if (valueProviderReslut == ValueProviderResult.None)
            {
                return Task.CompletedTask;
            }

            string valueString = valueProviderReslut.First(); //1233，233

            if (Regex.IsMatch(valueString, @"\d+,\d+"))
            {
                string[] lantLngStringArr = valueString.Split(',');

                int[] latlngValue = Array.ConvertAll(lantLngStringArr,o=>Convert.ToInt32(o));

                Geolocation geolocation = new Geolocation(latlngValue[0], latlngValue[1]);

                bindingContext.Result = ModelBindingResult.Success(geolocation);
            }

            return Task.CompletedTask;

        }
    }
}
