﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authentication.Cookies;
using Microsoft.AspNetCore.Mvc;
using SignalRCharSample.Datas;
using SignalRCharSample.Models;
using Microsoft.AspNetCore.Authentication;
using Microsoft.AspNetCore.Authorization;

namespace SignalRCharSample.Controllers
{
    public class UserController : Controller
    {
        [Authorize]
        public IActionResult Index()
        {
            return View();
        }

        [HttpGet]
        public IActionResult Login(string returnUrl)
        {
            return View();
        }

        [HttpPost]
        public IActionResult Login([FromServices] IUserRepository userRepository, LoginModel loginModel)
        {
            User user = userRepository.GetUsers().SingleOrDefault(u => u.UserName == loginModel.UserName && u.Password == loginModel.Password);

            if (user == null)
            {
                ModelState.AddModelError("", "无效的用户名密码");
                return View(loginModel);
            }

            var chaims = new[] { new Claim("UserName", user.UserName), new Claim("UserID", user.ID.ToString()) };
            var chaimsIdentity = new ClaimsIdentity(chaims, CookieAuthenticationDefaults.AuthenticationScheme);
            ClaimsPrincipal claimsPrincipal = new ClaimsPrincipal(chaimsIdentity);

            HttpContext.SignInAsync(CookieAuthenticationDefaults.AuthenticationScheme, claimsPrincipal).Wait();

            return RedirectToAction(nameof(Index));
        }

        [Authorize]
        public IActionResult Logout()
        {
            HttpContext.SignOutAsync().Wait();
            return RedirectToAction(nameof(Login));
        }
    }
}