﻿using Microsoft.AspNetCore.SignalR;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Channels;
using System.Threading.Tasks;
using System.IO;

namespace SignalRCharSample.Hubs
{
    public class StreamHub : Hub
    {
        public ChannelReader<string> ReadLogStream()
        {
            var channel = Channel.CreateUnbounded<string>();
            _ = WriteFileLine(channel.Writer);

            return channel.Reader;
        }

        private async Task WriteFileLine(ChannelWriter<string> writer)
        {
            using (var streamReader = new StreamReader(Directory.GetCurrentDirectory() + "/logs/server.log"))
            {
                string line;
                while ((line = streamReader.ReadLine()) != null)
                {
                    await writer.WriteAsync(line);
                    await Task.Delay(TimeSpan.FromSeconds(2));
                }

                writer.TryComplete();
            }
        }
    }
}
