﻿using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Localization;
using Microsoft.AspNetCore.Localization.Routing;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Threading.Tasks;

namespace LocalSamples.Filters
{
    public class LocalizationPipeline
    {
        public void Configure(IApplicationBuilder applicationBuilder)
        {
            var supportedCultures = new[] { new CultureInfo("en-US"), new CultureInfo("zh-CN") };

            var localizatiionOptions = new RequestLocalizationOptions
            {
                SupportedCultures = supportedCultures,
                SupportedUICultures = supportedCultures,
                DefaultRequestCulture = new RequestCulture("zh-CN"),
            };

            localizatiionOptions.RequestCultureProviders.Clear();

            localizatiionOptions.RequestCultureProviders.Add(new RouteDataRequestCultureProvider());

            applicationBuilder.UseRequestLocalization(localizatiionOptions);
        }
    }
}
