﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Localization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Localization;

namespace LocalSamples.Controllers
{
    public class StringLocalizerController : Controller
    {
        private readonly IStringLocalizer localizer;

        private readonly IStringLocalizer localizer2;

        public StringLocalizerController(IStringLocalizer<StringLocalizerController> localizer, IStringLocalizerFactory factory)
        {
            this.localizer = localizer;
            localizer2 = factory.Create("SharedResource", "LocalSamples");
        }

        public IActionResult Index()
        {
            ViewBag.HelloWorld = localizer["helloworld"];
            return View();
        }

        public IActionResult SharedResource()
        {
            return Content(localizer2["websiteName"]);
        }

        public IActionResult SetLanguage(string culture)
        {
            Response.Cookies.Append(CookieRequestCultureProvider.DefaultCookieName, CookieRequestCultureProvider.MakeCookieValue(new RequestCulture(culture)), new CookieOptions { Expires = DateTimeOffset.UtcNow.AddYears(1) });

            return Content("Cookie Write OK");
        }
    }
}