﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using LocalSamples.Models;
using System.Globalization;

namespace LocalSamples.Controllers
{
    public class HomeController : Controller
    {
        public IActionResult Index()
        {
            return Content($"Culture:{CultureInfo.CurrentCulture.Name}, "
                +$"CurrentDateTime:{DateTime.Now.ToString()}, "
                +$"Memory:{20.50.ToString("C")}"
                );
        }

        public IActionResult About()
        {
            ViewData["Message"] = "Your application description page.";

            return View();
        }

        public IActionResult Contact()
        {
            ViewData["Message"] = "Your contact page.";

            return View();
        }

        public IActionResult Privacy()
        {
            return View();
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
