using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;

namespace WorkerClient
{
    public class Worker : BackgroundService
    {
        private readonly ILogger<Worker> _logger;
        private readonly IHttpClientFactory _clientFactory;

        public Worker(ILogger<Worker> logger, IHttpClientFactory factory)
        {
            _logger = logger;
            _clientFactory = factory;
        }

        protected override async Task ExecuteAsync(CancellationToken stoppingToken)
        {
            while (!stoppingToken.IsCancellationRequested)
            {
                Console.WriteLine(Environment.NewLine);

                _logger.LogInformation("Worker running at: {time}", DateTime.Now);

                HttpClient client = _clientFactory.CreateClient("myClient");

                var response = await client.GetAsync("identity", stoppingToken);

                if (response.IsSuccessStatusCode)
                {
                    var content = await response.Content.ReadAsStringAsync();
                    _logger.LogInformation("API response: {response}", content);
                }
                else
                {
                    _logger.LogError("API returned: {statusCode}", response.StatusCode);
                }

                await Task.Delay(5000, stoppingToken);
            }
        }
    }
}
