﻿using System.Net.Http;
using System.Threading.Tasks;

namespace MvcClient
{
    public abstract class TypedClient
    {
        private readonly HttpClient _client;

        public TypedClient(HttpClient client)
        {
            _client = client;
        }

        public virtual async Task<string> CallApi()
        {
            return await _client.GetStringAsync("identity");
        }
    }

    public class TypedIdTokenClient : TypedClient
    {
        public TypedIdTokenClient(HttpClient client) : base(client)
        {
           
        }
    }

    public class TypedTokenClient : TypedClient
    {
        public TypedTokenClient(HttpClient client) : base(client)
        {
        }
    }
}