using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using IdentityModel.Client;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;

namespace WorkerClient
{
    public class Program
    {
        public static void Main(string[] args)
        {
            Task.Delay(TimeSpan.FromSeconds(5)).Wait();

            CreateHostBuilder(args).Build().Run();
        }

        public static IHostBuilder CreateHostBuilder(string[] args) =>
            Host.CreateDefaultBuilder(args)
                .ConfigureServices((hostContext, services) =>
                {
                    services.AddAccessTokenManagement(options =>
                    {
                        options.Client.Clients.Add("myServer", new ClientCredentialsTokenRequest
                        {
                            Address = "https://localhost:5001/connect/token",
                            ClientId = "client",
                            ClientSecret = "secret",
                            Scope = "identity.read identity.write identity.get"
                        });
                    });

                    services.AddClientAccessTokenClient("myClient", configureClient: client =>
                    {
                        client.BaseAddress = new Uri("https://localhost:6001");
                    });

                    services.AddHostedService<Worker>();
                });
    }
}
