﻿using Microsoft.AspNetCore.Authentication;
using Microsoft.AspNetCore.Authentication.Cookies;
using Microsoft.AspNetCore.Authentication.OpenIdConnect;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using Microsoft.IdentityModel.Protocols.OpenIdConnect;
using MvcClient.Models;
using Newtonsoft.Json.Linq;
using System.Diagnostics;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Threading.Tasks;

namespace MvcClient.Controllers
{
    [Authorize]
    public class HomeController : Controller
    {
        private readonly ILogger<HomeController> _logger;

        private readonly IHttpClientFactory _clientFactory;

        public HomeController(ILogger<HomeController> logger, IHttpClientFactory factory)
        {
            _logger = logger;
            _clientFactory = factory;
        }

        public async Task<IActionResult> Index()
        {
            string accessToken = await HttpContext.GetTokenAsync(OpenIdConnectParameterNames.AccessToken);

            string idToken = await HttpContext.GetTokenAsync(OpenIdConnectParameterNames.IdToken);

            string refreshToken = await HttpContext.GetTokenAsync(OpenIdConnectParameterNames.RefreshToken);

            _logger.LogTrace($"token={accessToken},idtoken={idToken},rtoken={refreshToken}");

            return View();
        }

        public async Task<IActionResult> CallApi()
        {
            //var idToken = await HttpContext.GetTokenAsync(OpenIdConnectParameterNames.IdToken);

            var token = await HttpContext.GetTokenAsync(OpenIdConnectParameterNames.AccessToken);

            //var refreshToken = await HttpContext.GetTokenAsync(OpenIdConnectParameterNames.RefreshToken);

            //var client = new HttpClient();

            var client = _clientFactory.CreateClient("defaultClient");

            client.DefaultRequestHeaders.Authorization = new AuthenticationHeaderValue("Bearer", token);

            var content = await client.GetStringAsync("https://localhost:6001/identity");

            ViewBag.Json = JArray.Parse(content).ToString();

            return View();
        }

        public async Task<IActionResult> CallApi2()
        {
            //var client = _clientFactory.CreateClient("idTokenClient");
            var client = _clientFactory.CreateClient("tokenClient");

            var content = await client.GetStringAsync("identity");

            ViewBag.Json = JArray.Parse(content).ToString();

            return View("CallApi");
        }

        public async Task<IActionResult> CallApi3([FromServices] TypedTokenClient tokenClient, [FromServices] TypedIdTokenClient itTokenClient)
        {
            var response1 = await itTokenClient.CallApi();
            var response2 = await tokenClient.CallApi();

            ViewBag.Json = JArray.Parse(response1).ToString() +System.Environment.NewLine+ JArray.Parse(response2);

            return View("CallApi");
        }

        public IActionResult Logout()
        {
            return SignOut(CookieAuthenticationDefaults.AuthenticationScheme, OpenIdConnectDefaults.AuthenticationScheme);
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}