﻿#define Microsoft_AspNetCore_Authentication_JwtBearer
//#define IdentityModel_AspNetCore_OAuth2Introspection
//#define IdentityServer4_AccessTokenValidation

// Copyright (c) Brock Allen & Dominick Baier. All rights reserved.
// Licensed under the Apache License, Version 2.0. See LICENSE in the project root for license information.

using Api.Extensions;
using IdentityModel.AspNetCore.OAuth2Introspection;
using IdentityServer4.AccessTokenValidation;
using Microsoft.AspNetCore.Authentication.JwtBearer;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Authorization;
using Microsoft.Extensions.DependencyInjection;
using System.IdentityModel.Tokens.Jwt;

namespace Api
{
    public class Startup
    {
        public void ConfigureServices(IServiceCollection services)
        {

            services.AddControllers();

            services.AddApiScopesAuthorization();

            //JwtSecurityTokenHandler.DefaultInboundClaimTypeMap.Clear();

#if (Microsoft_AspNetCore_Authentication_JwtBearer)

            services.AddAuthentication(JwtBearerDefaults.AuthenticationScheme)
                .AddJwtBearer(JwtBearerDefaults.AuthenticationScheme, options =>
                {
                    options.Authority = "https://localhost:5001";
                    options.RequireHttpsMetadata = false;

                    options.TokenValidationParameters.ValidateAudience = false;
                });
#endif

#if (IdentityModel_AspNetCore_OAuth2Introspection)

            services.AddAuthentication(OAuth2IntrospectionDefaults.AuthenticationScheme)
                .AddOAuth2Introspection(options =>
                {
                    options.Authority = "https://localhost:5001";

                    options.ClientId = "identity";
                    options.ClientSecret = "apisecret";
                });

#endif

#if (IdentityServer4_AccessTokenValidation)

            services.AddDistributedMemoryCache();

            services.AddAuthentication(IdentityServerAuthenticationDefaults.AuthenticationScheme)
                .AddIdentityServerAuthentication(options =>
                {
                    // base-address of your identityserver
                    options.Authority = "https://localhost:5001";

                    // name of the API resource
                    options.ApiName = "identity";
                    options.ApiSecret = "apisecret";

                    options.EnableCaching = true;
                    options.CacheDuration = System.TimeSpan.FromMinutes(10); // that's the default
                });

            services.AddAuthorization(options =>
            {
                options.AddPolicy("myPolicy", builder =>
                {
                    // require scope1
                    builder.RequireScope("identity.write");
                    // and require scope2 or scope3
                    builder.RequireScope("identity.read", "identity.write");
                });
            });

            services.Configure<MvcOptions>(options =>
            {
                // require scope1 or scope2
                var policy = ScopePolicy.Create("identity.read", "identity.write");
                options.Filters.Add(new AuthorizeFilter(policy));
            });

#endif

            services.AddAuthorization();

            services.AddCors(options =>
            {
                // this defines a CORS policy called "default"
                options.AddPolicy("default", policy =>
                {
                    policy.WithOrigins("https://localhost:5003")
                        .AllowAnyHeader()
                        .AllowAnyMethod();
                });
            });
        }

        public void Configure(IApplicationBuilder app)
        {
            app.UseRouting();

            app.UseCors("default");

            app.UseAuthentication();
            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });
        }
    }
}