﻿using Microsoft.AspNetCore.Authorization;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Api.Extensions
{
    public class ApiScopesRequirement : IAuthorizationRequirement
    {
        /// <summary>
        /// Creates a new instance of <see cref="ApiScopesRequirement"/>.
        /// </summary>
        /// <param name="allowedApiScopes">A collection of allowed apiScopess.</param>
        public ApiScopesRequirement(IEnumerable<string> allowedApiScopes)
        {
            if (allowedApiScopes == null)
            {
                throw new ArgumentNullException(nameof(allowedApiScopes));
            }

            if (!allowedApiScopes.Any())
            {
                throw new InvalidOperationException("At least one scope must be specified.");
            }
            AllowedApiScopes = allowedApiScopes;
        }

        /// <summary>
        /// Gets the collection of allowed apiScopess.
        /// </summary>
        public IEnumerable<string> AllowedApiScopes { get; }
    }
}
