﻿using Microsoft.AspNetCore.Authorization;

namespace Api.Extensions
{
    public class ApiScopeAuthorizeAttribute : AuthorizeAttribute
    {
        const string POLICY_PREFIX = "scopes.";

        public ApiScopeAuthorizeAttribute(string scopes) => Scopes = scopes;

        // Get or set the Age property by manipulating the underlying Policy property
        public string Scopes
        {
            get
            {
                return Policy.Substring(POLICY_PREFIX.Length);
            }
            set
            {
                Policy = $"{POLICY_PREFIX}{value}";
            }
        }
    }
}
