﻿using Microsoft.AspNetCore.Authorization;
using System.Linq;
using System.Threading.Tasks;

namespace Api.Extensions
{
    // This class contains logic for determining whether ApiScopesRequirement in authorization
    // policies are satisfied or not
    internal class ApiScopesAuthorizationHandler : AuthorizationHandler<ApiScopesRequirement>
    {

        // Check whether a given MinimumAgeRequirement is satisfied or not for a particular context
        protected override Task HandleRequirementAsync(AuthorizationHandlerContext context, ApiScopesRequirement requirement)
        {
            if (context.User != null)
            {
                bool found = false;

                if (requirement.AllowedApiScopes == null || !requirement.AllowedApiScopes.Any())
                {
                    // Review: What do we want to do here?  No apiScopess requested is auto success?
                }
                else
                {
                    found = requirement.AllowedApiScopes.Any(s => context.User.HasClaim(c => c.Type == "scope" && c.Value == s));
                }

                if (found)
                {
                    context.Succeed(requirement);
                }
            }

            return Task.CompletedTask;
        }
    }
}
