﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc.ApplicationModels;
using Microsoft.AspNetCore.Mvc.Authorization;
using System.Linq;

namespace Api.Extensions
{
    public class ApiScopesActionModelConvention : IActionModelConvention
    {
        public void Apply(ActionModel action)
        {
            var controllerModelAuthData = action.Controller.Attributes.OfType<IAuthorizeData>().ToArray();

            var actionModelAuthData = action.Attributes.OfType<IAuthorizeData>().ToArray();

            if (!actionModelAuthData.Any() && !controllerModelAuthData.Any())
            {
                string policyName = $"scopes.{action.Controller.ControllerName}.{action.ActionName}".ToLower();

                action.Filters.Add(new AuthorizeFilter(policyName));
            }
        }
    }
}