﻿using Microsoft.AspNetCore.Http;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using ProtoBuf;

namespace StateSample
{
    public static class SessionExtensions
    {
        public static void SetObject<T>(this ISession session, string key, T value)
        {
            using (MemoryStream stream=new MemoryStream())
            {
                Serializer.Serialize(stream,value);
                byte[] byteArrary = stream.ToArray();
                session.Set(key,byteArrary);
            }
        }

        public static T GetObject<T>(this ISession session, string key)
        {
            byte[] byteArray = session.Get(key);

            using (MemoryStream stream = new MemoryStream(byteArray))
            {
               return  Serializer.Deserialize<T>(stream);
            }
        }
    }
}
