﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.ViewFeatures;
using Newtonsoft.Json;
using StateSample.Models;

namespace StateSample.Controllers
{
    public class HomeController : Controller
    {
        private readonly IHttpContextAccessor httpContextAccessor;

        private ISession session => httpContextAccessor.HttpContext.Session;

        public HomeController(IHttpContextAccessor httpContextAccessor)
        {
            this.httpContextAccessor = httpContextAccessor;
        }

        public IActionResult Index()
        {
          
            return View();
        }

        public IActionResult About()
        {
            ViewData["Message"] = "Your application description page.";

            return View();
        }

        public IActionResult Contact()
        {
            ViewData["Message"] = "Your contact page.";

            return View();
        }

        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }

        public IActionResult Loggin(string userName, string pwd)
        {
            HttpContext.Session.SetObject("userInfo",new object());

            object user = HttpContext.Session.GetObject<object>("userInfo");

            if (!string.IsNullOrWhiteSpace(userName))
            {
              
                HttpContext.Session.SetString("userInfo",JsonConvert.SerializeObject(new object()));
                return RedirectToAction(nameof(Manager));
            }
            else
            {
                return Content("ERROR");
            }
        }

        public IActionResult Manager()
        {
            string str = HttpContext.Session.GetString("userName");
            return Content(str);
        }

        public IActionResult Test1()
        {
            TempData["key"] = "value";
            return RedirectToAction(nameof(Test2));
        }

        public IActionResult Test2()
        {
            return RedirectToAction(nameof(Test3));
        }

        public IActionResult Test3()
        {
            string value = TempData["key"].ToString(); //拿不到

            return Content(value);
        }
    }
}
