﻿using EntityFrameworkCoreSample.Models;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Logging.Console;
using System;
using System.IO;

namespace EntityFrameworkCoreSample
{
    class Program
    {
        static void Main()
        {
            ServiceCollection serviceCollection = new ServiceCollection();

            var configurationBuilder = new ConfigurationBuilder().SetBasePath(Directory.GetCurrentDirectory()).AddJsonFile("appsettings.json");

            var configuration = configurationBuilder.Build();

            using (ILoggerFactory myLoggerFactory = LoggerFactory.Create(builder => { _ = builder.AddConsole(); }))
            {
                serviceCollection.AddDbContext<BloggingContext>(options => options.UseSqlServer(configuration.GetConnectionString("blogging")).UseLoggerFactory(myLoggerFactory).EnableSensitiveDataLogging());
            }

            var services = serviceCollection.BuildServiceProvider();

            var instance = ActivatorUtilities.CreateInstance<MyClass>(services);

            instance.RunSample().Wait();

            Console.WriteLine("Hello World!");

            Console.ReadKey();
        }
    }
}
