﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Data;
using System.Text;

namespace EntityFrameworkCoreSample
{
    public static class ReadWriteExtensions
    {
        /// <summary>
        /// Changes the database name. This require the databases in the same machine. NOTE: This only work for MySQL right now.
        /// </summary>
        /// <param name="database">The database name.</param>
        /// <remarks>
        /// This only been used for supporting multiple databases in the same model. This require the databases in the same machine.
        /// </remarks>
        public static void ChangeDatabase(this DbContext dbContext, string nameOrConnectionString)
        {
            var connection = dbContext.Database.GetDbConnection();

            if (connection.State.HasFlag(ConnectionState.Open))
            {
                connection.ChangeDatabase(nameOrConnectionString);
            }
            else
            {
                connection.ConnectionString = nameOrConnectionString;
            }
        }
    }
}