﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace EntityFrameworkCoreSample
{
    public class StringContainsAttribute: ValidationAttribute
    {
        public string ContainsSubString { get; }

        public StringContainsAttribute(string containsSubString)
        {
            ContainsSubString = containsSubString;
        }

        public override bool IsValid(object value)
        {
            string valueString = value.ToString();

            if (string.IsNullOrWhiteSpace(ContainsSubString))
            {
                throw new InvalidOperationException("Substring cannot be null or empty.");
            }

            if (ContainsSubString.Length > valueString.Length)
            {
                throw new InvalidOperationException("Invalid length of the substring.");
            }

            return valueString.Contains(ContainsSubString);
        }

        public override string FormatErrorMessage(string name)
        {
            return $"{name} does not contains {ContainsSubString}";
        }

    }
}
