﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;
using FluentValidation;
using FluentValidation.Results;
using JetBrains.Annotations;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using Microsoft.EntityFrameworkCore.Metadata.Internal;
using Microsoft.Extensions.DependencyInjection;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<Blog>().Property(b => b.Name).HasAnnotation("MinLength", 3).HasMaxLength(10).IsRequired();

            base.OnModelCreating(modelBuilder);
        }

        //public override int SaveChanges()
        //{
        //    var entityEntrys = ChangeTracker.Entries().Where(e => e.State == EntityState.Added || e.State == EntityState.Modified);

        //    foreach (EntityEntry entityEntry in entityEntrys)
        //    {
        //        IEntityType entityType = Model.FindEntityType(entityEntry.Entity.GetType().FullName);

        //        var validationContext = new ValidationContext(entityEntry.Entity);

        //        Validator.ValidateObject(entityEntry.Entity, validationContext, true);

        //        foreach (IProperty property in entityType.GetProperties())
        //        {
        //            var validationAttributes = new List<ValidationAttribute>();

        //            int? maxLength = property.GetMaxLength();

        //            if (maxLength.HasValue)
        //            {
        //                validationAttributes.Add(new MaxLengthAttribute(maxLength.Value));
        //            }

        //            if (!property.IsNullable)
        //            {
        //                validationAttributes.Add(new RequiredAttribute());
        //            }

        //            foreach (IAnnotation annotation in property.GetAnnotations())
        //            {
        //                var validationAttributeTypes = typeof(ValidationAttribute).Assembly.GetTypes().Where(t => t.IsSubclassOf(typeof(ValidationAttribute)));
        //                string attributeTypeName = string.Concat(annotation.Name, "Attribute");

        //                var validationAttribute = validationAttributeTypes.SingleOrDefault(t => t.Name.Equals(attributeTypeName));

        //                if (validationAttribute != null)
        //                {
        //                    var attributeInstance = Activator.CreateInstance(validationAttribute, annotation.Value) as ValidationAttribute;
        //                    validationAttributes.Add(attributeInstance);
        //                }
        //            }

        //            var currentValue = entityEntry.Property(property.Name).CurrentValue;

        //            Validator.ValidateValue(currentValue, validationContext, validationAttributes);
        //        }
        //    }

        //    return base.SaveChanges();
        //}

        public override int SaveChanges()
        {
            var entityEntrys = ChangeTracker.Entries().Where(e => e.State == EntityState.Added || e.State == EntityState.Modified);

            foreach (EntityEntry entityEntry in entityEntrys)
            {
                var abstractValidatorType = typeof(AbstractValidator<>).MakeGenericType(entityEntry.Entity.GetType());
                var modelValidatorType = Assembly.GetExecutingAssembly().GetTypes().FirstOrDefault(t => t.IsSubclassOf(abstractValidatorType));

                var modelValidatorInstance = (IValidator)Activator.CreateInstance(modelValidatorType);

                var validationResult = modelValidatorInstance.Validate(entityEntry.Entity);

                if (!validationResult.IsValid)
                {
                    throw new FluentValidation.ValidationException(validationResult.Errors);
                }
            }

            return base.SaveChanges();
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }
    }
}
