﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace EntityFrameworkCoreSample.Models
{
    public class Blog: IValidatableObject
    {
        public int BlogId { get; set; }

        [Required,MinLength(3)]
        //[StringContains("NB")]
        public string Name { get; set; }

        public string Url { get; set; }

        public List<Post> Posts { get; set; }

        public IEnumerable<ValidationResult> Validate(ValidationContext validationContext)
        {
            if (!Name.Contains("NB"))
            {
                yield return new ValidationResult("Blog name does not contain NB.", new[] { nameof(Name) });
            }
        }
    }
}
