﻿using System;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;
using EntityFrameworkCoreSample.Mapping;
using JetBrains.Annotations;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using Microsoft.EntityFrameworkCore.Metadata.Internal;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {
                optionsBuilder.UseSqlServer("connectionString").EnableSensitiveDataLogging();
            }

            base.OnConfiguring(optionsBuilder);
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //foreach (IMutableEntityType entityType in modelBuilder.Model.GetEntityTypes())
            //{
            //    entityType.Relational().TableName = entityType.DisplayName();
            //}

            //foreach (IMutableEntityType entityType in modelBuilder.Model.GetEntityTypes())
            //{
            //    modelBuilder.Entity(entityType.Name).ToTable($"T_{ entityType.DisplayName()}");
            //}

            //foreach (IMutableEntityType entityType in modelBuilder.Model.GetEntityTypes())
            //{
            //    foreach (IMutableProperty property in entityType.GetProperties().Where(p => p.ClrType == typeof(string)))
            //    {
            //        property.SetMaxLength(20);
            //    }
            //}

            //foreach (IMutableEntityType entityType in modelBuilder.Model.GetEntityTypes())
            //{
            //    foreach (IMutableProperty property in entityType.GetProperties().Where(p => p.ClrType == typeof(string)))
            //    {
            //        modelBuilder.Entity(entityType.Name).Property(property.Name).HasMaxLength(50).HasColumnName($"S_{property.Name}");
            //    }
            //}

            //modelBuilder.Entity<Blog>().Property(b => b.Url).HasColumnName("BlogUrl");
            //modelBuilder.Entity<Blog>().Property(b => b.Name).HasMaxLength(50);

            //modelBuilder.Entity<Post>().Property(b => b.Title).HasMaxLength(30);
            //modelBuilder.Entity<Post>().Property(b => b.Content).HasMaxLength(500);

            //modelBuilder.Entity<Blog>(buildAction =>
            //{
            //    buildAction.Property(b => b.Url).HasColumnName("BlogUrl");
            //    buildAction.Property(b => b.Name).HasMaxLength(50);
            //});

            //modelBuilder.Entity<Post>(buildAction =>
            //{
            //    buildAction.Property(b => b.Title).HasMaxLength(30);
            //    buildAction.Property(b => b.Content).HasMaxLength(500);
            //});

            //modelBuilder.Entity<Blog>(ConfigureBlog);
            //modelBuilder.Entity<Post>(ConfigurePost);

            //modelBuilder.ApplyConfiguration(new BlogConfiguration());
            //modelBuilder.ApplyConfiguration(new PostConfiguration());

            modelBuilder.ApplyConfigurationsFromAssembly(Assembly.GetExecutingAssembly());

            base.OnModelCreating(modelBuilder);
        }

        private void ConfigureBlog(EntityTypeBuilder<Blog> buildAction)
        {
            buildAction.Property(b => b.Url).HasColumnName("BlogUrl");
            buildAction.Property(b => b.Name).HasMaxLength(50);
        }

        private void ConfigurePost(EntityTypeBuilder<Post> buildAction)
        {
            buildAction.Property(b => b.Title).HasMaxLength(30);
            buildAction.Property(b => b.Content).HasMaxLength(500);
        }

        public override EntityEntry<TEntity> Remove<TEntity>(TEntity entity)
        {
            //TODO
            var result = base.Remove(entity);
            //TODO

            return result;
        }

        public override int SaveChanges()
        {
            return base.SaveChanges();
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }
    }
}
