﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;
using System.Linq.Expressions;
using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace EntityFrameworkCoreSample
{
    public static class DbContextMetadataExtensions
    {
        public static IProperty FindProperty<TEntity, TProperty>(this DbContext dbContext, Expression<Func<TEntity, TProperty>> expression)
        {
            //blog=>blog.Url
            MemberExpression memberExpression = expression.Body as MemberExpression;
            PropertyInfo propertyInfo = typeof(TEntity).GetProperty(memberExpression.Member.Name);

            IEntityType entityType = dbContext.Model.FindEntityType(typeof(TEntity).FullName);
            IProperty property = entityType.FindProperty(propertyInfo.Name);

            return property;
        }
    }
}
